up:: [[LYT Kit]]
tags:: #on/PKM 

# Benefits of LYT frameworks
Folks relying solely on direct links, tags, and folders are missing out on a bevy of benefits. Below is a list of benefits derived from having your notes equipped with fluid frameworks like a **Home note** and **Maps of Content**.

---
## Benefits
###### Provides Reliability
Having a Home note and MOCs act as reliable home bases to re-ground your thoughts whenever they begin to waver. Like a parent to a five-year old, linked frameworks like MOCs are a consistent and comforting safety net. 
 
Disregard this at your own peril.  [^1]


### Provides Flexibility
> [[Fluid Frameworks]] like the Home note and Maps of Content *don't limit access; they curate it.* 

They are like a top-notch concierge that directs you to where you want to be. 

See [[Why Categories for Your Notes are a Good Idea]].

#### Launches the Brain 
The LYT framework is filled with your personalized reminders of important categories of knowledge and their key terms. It helps kickstart the brain—reducing the activation energy needed to start thinking and connecting ideas.

##### Enhances Note Retrieval
Note retrieval becomes easier when you're staring at many possible access points: your main categories, contexts, maps, and tags. [^2] Notes become tethered like Wolverine:
![[wolverine-tethered.jpg]]

### Alleviates Overwhelm
[[MOCs Overview]] (MOCs) are your key to adding structure to the chaos, especially as your digital library grows. The ability to sense the tickle of anxiety and build an MOC is oftentimes the difference between a finished project and an abandoned one.

### Encourages Relational, Positional Thinking 
***Making a Map of Content forces a rich, engaging relational battle between notes.*** Notes jockey for position in your brain, and each placement by you embeds them with additional meaning.

### Aids in Linking with Pre-built Contexts
Your 10 or so [[Figuring out your Home MOCs|main maps]] provide a pre-built latticework upon which to hang your new notes. It's a personalized classification system for your digital knowledge. Tethering to these hub-like maps vastly enhance long-term storage and retrieval.

### Future-Proofs for your Future Self
There are months that go by where I don't open my digital library. Before adopting plain text and adding structure, I would get anxiety when I would finally re-open it. Now, however, I don't get that anxiety because I have my trusty **Home note**, **Maps of Content** and other fluid ways of categorizing and retrieving info. In no time, I'm back up to speed and off to the races.

### Improves Memory
![[Reps#^dbdd21]]

Because of the well-traveled structural pathways that the Home note and Maps of Content encourage, my recall has improved. This makes sense because of three important factors that working with "linked frameworks" encourages:

1. [[Reps]] - I'm constantly returning to a home view and then re-launching into new directions in my digital library. 
2. Conceptual Thinking - Making MOCs forces you to really consider the unique qualities of the thought you're holding and how it relates to other thoughts. This conceptual `[[thinking through linking]]` strengthens neural connections—making [[Cobwebs into Cables]].
3. [[Spatial Context]] - Your main MOCs are numbered and always at the top of the sidebar (when sorted A to Z). This way, they act as a spatial map. We remember things much better when we have a *spatial constellation* of related things. 

### Increases Satisfaction
We spend too much time with our notes not to experience joy with them. ==LYT structures allow you to fly around your digital library with the deftness of a surgeon and the joy of a chimpanzee swinging from branch to branch.== 

%%

---
Did you know this article is LIVE online right now, but no one online can see these hidden "comments" except us :)

Wow, this note uses at least 18 different formatting methods:

```
internal links, embeds, headers, dividers, emphasis with bolds, italics, bold+italics, lists, images, piped links, external links, blockquotes, inline code, tables, strikethroughs, highlights, footnotes, and comments. 
```

## The first three benefits as a table
| Benefit              | Description                               |
| -------------------- | ----------------------------------------- |
| Provides Reliability | Reliable places to ground thoughts        |
| Provides Flexibility | Fluid frameworks don't limit, they curate |
| Launches the Brain   | ~~Jump~~ Kickstarts your brain                     | 

%%

---
## Next
The benefits are exhaustive—and we haven't even talked about [Idea Emergence](https://twitter.com/NickMilo/status/1317190776284086272)!

But you may still be asking: [[Is LYT For Me]]?


[^1]: Do not underestimate the peace of mind that comes from a reliable, dependable digital library. Being unable to access something you know you have is basically a form of "Digital Dementia". 
[^2]: I like to make my digital library super robust. That means I have several avenues built-in to re-discover a note. I find this process of "connecting to conceptual cousins" further cements each idea into my memory. It sort of tethers things in place like Wolverine, or if you prefer, like a bug caught on a spider web. 